%% Read GGOR basic data from Excel file and put the relevant info in the
%% struct GG
% TO 100615

%% Get Data from Excel file
[parnams,parvals]=getExcelData('GGOR_basisdata_Noorderpark.xls','GGOR_noo','H');

%% Print statistics of what has been read

stat=[max(parvals); mean(parvals); median(parvals); min(parvals)];
for i=1:length(parnams)
    fprintf('%20s %15g %15g %15g %15g\n',parnams{i},stat(:,i));
end

%% Only keep the columns with the names in parameter lbl, as the others
% contain no numeric data

lbl={'FID','PEIL','Zomerpeil','Winterpeil','L','XC','YC','K','MU','C','WVP','GLGNEW','GVGNEW','GHGNEW','AHN','KWEL_GEM'};
I=NaN(size(lbl));
for i=1:length(I)
    I(i)=strmatchi(lbl{i},parnams,'exact');
end
parnams=parnams(I);
parvals=parvals(:,I);

%% Print statistis once more

stat=[max(parvals); mean(parvals); median(parvals); min(parvals)];
for i=1:length(parnams)
    fprintf('%20s %15g %15g %15g %15g\n',parnams{i},stat(:,i));
end

%% Remove extreme values, which I think indicate errors
% whic columns follows from the statistics print above

i=strmatchi('WVP'     ,parnams); I=find(abs(parvals(:,i))>100); parvals(I,i)=parvals(I,strmatchi('PEIL',parnams))-10;
i=strmatchi('AHN'     ,parnams); I=find(abs(parvals(:,i))> 0.5); parvals(I,i)=parvals(I,strmatchi('PEIL',parnams))+ 1;
i=strmatchi('KWEL_GEM',parnams); I=find(abs(parvals(:,i))>100); parvals(I,i)=0;

%% Once more, print statistics

stat=[max(parvals); mean(parvals); median(parvals); min(parvals)];
for i=1:length(parnams)
    fprintf('%20s %15g %15g %15g %15g\n',parnams{i},stat(:,i));
end

%% Plot all colnumns

if 0
    close all;
    for i=1:length(parnams)
        if ~all(isnan(parvals(i,:)))
            figure
            plot(parvals(:,i)); title(sprintf('%s',parnams{i}));
        end
    end
end

%% Locations

ix=strmatchi('XC',parnams); xP=parvals(:,ix);
iy=strmatchi('YC',parnams); yP=parvals(:,iy);

%% Remove non-unique lines

[xy,I]=unique([xP yP],'rows'); % I is the list of the last non-unique label
parvals=parvals(I,:); xP=xP(I); yP=yP(I);

%% Show locations

figure; hold on

plot(xP,yP,'o'); title('coordinates');

% and a bounding box around them
box=100*round([min(xP) min(yP) max(xP) max(yP)])/100;

plot(box([1 3 3 1 1]),box([2 2 4 4 2]));

%% Make grid to allow contouring the irregula data point values

xGr=box(1):100:box(3);
yGr=box(2):100:box(4);

[xGr,yGr,xm,ym,Dx,Dy,Nx,Ny]=modelsize(xGr,yGr);
[XM,YM]=meshgrid(xm,ym);

%% contouring the data of te columns indicated by the following labels
% Put the data in the GG struct to be saved for later usage witihout the
% excel sheet. GG stands for GGOR

Lbl={'PEIL','Zomerpeil','Winterpeil','L','K','MU','C','WVP','AHN','KWEL_GEM'};
GG=[];
GG(length(Lbl)).zData=NaN;
for i=1:length(Lbl)
    figure; hold on;
    j=strmatchi(Lbl{i},parnams,'exact');
    GG(i).name=Lbl{i};
    GG(i).xData=xm;
    GG(i).yData=ym;
    GG(i).zData=griddata(xP,yP,parvals(:,j),XM,YM);
    GG(i).data=parvals(:,j);
    GG(i).xP=xP;
    GG(i).yP=yP;
    GG(i).FID=parvals(:,strmatchi('FID',parnams,'exact'));
    
    % Show the data
    contourf(GG(i).xData,GG(i).yData,GG(i).zData); colorbar;
    xlabel('x [m]'); ylabel('y [m]'); title(GG(i).name);
end

save GG GG parnams parvals

fprintf('Done, struct GG saved into file GG.mat\n');